(************************************************************************
 *                                                                      *
 *   Ant Movie Catalog 4.x                                              *
 *   (C) 2005-2006 Antoine Potten                                       *
 *   http://www.antp.be/software                                        *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************)

unit import2;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, ImgList,

  AntCorelButton, AntAutoHintLabel,

  base, MovieClass, import2_engines, import2_frame;

type
  TImportWin2 = class(TBaseDlg)
    PanelMain: TPanel;
    lvFormat: TListView;
    Splitter1: TSplitter;
    FormatImages: TImageList;
    procedure btn1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure lvFormatSelectItem(Sender: TObject; Item: TListItem; Selected: Boolean);
    procedure btn3Click(Sender: TObject);
  private
    FCurrentFrame: TImportFrame;
    FCurrentList: TMovieList;
    FCurrentFile: TFileName;
  protected
    procedure LoadOptions; override;
    procedure SaveOptions; override;
  public
    function Execute(const CurrentFileName: TFileName; CurrentList: TMovieList): Boolean;
    procedure Translate; override;
  end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

implementation

{$R *.dfm}

uses
  Global, functions_files, import2_frameCsv, import2_frameQuery;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

function TImportWin2.Execute(const CurrentFileName: TFileName; CurrentList: TMovieList): Boolean;
begin
  FCurrentList := CurrentList;
  FCurrentFile := CurrentFileName;
  Result := ShowModal = mrOk;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TImportWin2.btn1Click(Sender: TObject);
begin
  functions_files.LaunchHelp(HelpContext);
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TImportWin2.FormDestroy(Sender: TObject);
begin
  FreeAndNil(FCurrentFrame);
  inherited;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TImportWin2.lvFormatSelectItem(Sender: TObject; Item: TListItem; Selected: Boolean);
var
  c: string;
begin
  FreeAndNil(FCurrentFrame);
  if (Item <> nil) and (Selected) then
  begin
    c := Item.Caption;
    case Item.Index of
      0: {CSV}FCurrentFrame := TImportFrameCSV.Create(Self,
        TImportEngineCsv.Create(c, FCurrentList.CustomFieldsProperties),
        'CSV', FCurrentList.CustomFieldsProperties);
      1: {AMC}FCurrentFrame := TImportFrame.Create(Self,
        TImportEngineAmc.Create(c, FCurrentList.CustomFieldsProperties),
        'AMC', FCurrentList.CustomFieldsProperties);
      2: {XMM}FCurrentFrame := TImportFrame.Create(Self,
        TImportEngineXmm.Create(c, FCurrentList.CustomFieldsProperties),
        'XMM', FCurrentList.CustomFieldsProperties);
      3: {BDV}FCurrentFrame := TImportFrame.Create(Self,
        TImportEngineBdv.Create(c, FCurrentList.CustomFieldsProperties),
        'BDV', FCurrentList.CustomFieldsProperties);
      4: {OGS}FCurrentFrame := TImportFrame.Create(Self,
        TImportEngineOgs.Create(c, FCurrentList.CustomFieldsProperties),
        'OGS', FCurrentList.CustomFieldsProperties);
      5: {MDB}FCurrentFrame := TImportFrameQuery.Create(Self,
        TImportEngineMdb.Create(c, FCurrentList.CustomFieldsProperties),
        'MDB', FCurrentList.CustomFieldsProperties);
      6: {Dvdpro}FCurrentFrame := TImportFrame.Create(Self,
        TImportEngineDvdpro.Create(c, FCurrentList.CustomFieldsProperties),
        'DVDPRO', FCurrentList.CustomFieldsProperties);
    end;
    if FCurrentFrame <> nil then
    begin
      FCurrentFrame.CatalogFile := FCurrentFile;
      FCurrentFrame.Align := alClient;
      FCurrentFrame.Parent := PanelMain;
      FCurrentFrame.LoadSettings;
      FCurrentFrame.Visible := True;
    end;
  end;
  btn3.Enabled := FCurrentFrame <> nil;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TImportWin2.LoadOptions;
begin
  with Settings.rImport do
    case WindowState of
      1:
        begin
          Self.WindowState := wsNormal;
          Self.Width := WindowWidth;
          Self.Height := WindowHeight;
        end;
      2:
        Self.WindowState := wsMaximized;
      else
        Self.WindowState := wsNormal;
    end;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TImportWin2.SaveOptions;
begin
  with Settings.rImport do
    if Self.WindowState = wsMaximized then
      WindowState := 2
    else
    begin
      WindowState := 1;
      WindowWidth := Width;
      WindowHeight := Height;
    end;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TImportWin2.btn3Click(Sender: TObject);
begin
  if FCurrentFrame <> nil then
    try
      FCurrentFrame.ImportToList(FCurrentList);
      ModalResult := mrOk;
    except
      on E: Exception do
        MessageWin.Execute(E.Message, mtError, [mbOk]);
    end;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TImportWin2.Translate;
begin
  if Assigned(FCurrentFrame) then
    Translator.Translate(FCurrentFrame);
  inherited;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

end.
